import { DEFAULT_SWR_OPTIONS_FOR_GLOBAL_VALUES } from "@/config/swr";
import { getStatewideServices } from "@/features/statewide-services/lib/actions";
import useSWR, { mutate } from "swr";

const INTERNAL__key = ["USE_GET_STATEWIDE_SERVICES"] as const

export function useGetStatewideServices() {
  return useSWR(INTERNAL__key,
    getStatewideServices,
    DEFAULT_SWR_OPTIONS_FOR_GLOBAL_VALUES
  )
}

export function revalidateGetStatewideServices() {
  return mutate((k) => k === INTERNAL__key, undefined, ({
    populateCache(_, currentData) {
      return currentData
    },
    revalidate: true,
  }))
}
